/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.mib;

import ibm.nways.jdm.mib.MibModule;
import ibm.nways.jdm.mib.MibRangeSubtype;
import ibm.nways.jdm.mib.MibValueSubtype;
import java.io.Serializable;

public class MibType
implements Serializable {
    public static final int UNKNOWN = 0;
    public static final int COUNTER = 1;
    public static final int GAUGE = 2;
    public static final int INTEGER = 3;
    public static final int IPADDRESS = 4;
    public static final int DISPLAYSTRING = 5;
    public static final int NETWORKADDRESS = 6;
    public static final int NSAPADDRESS = 7;
    public static final int OI = 8;
    public static final int OCTETSTRING = 9;
    public static final int OPAQUE = 10;
    public static final int SEQUENCE = 11;
    public static final int SEQUENCEOF = 12;
    public static final int TIMETICKS = 13;
    public static final int BITSTRING = 14;
    public static final int COUNTER64 = 15;
    public static final int ENUMERATED = 16;
    public static final int BOOLEAN = 17;
    public String name;
    public String displayHint;
    protected transient MibModule module;
    protected MibValueSubtype allowedValues;
    protected MibRangeSubtype range;
    protected boolean inTable;

    public MibType(MibModule mibModule) {
        this.name = null;
        this.displayHint = null;
        this.range = null;
        this.allowedValues = null;
        this.module = mibModule;
        this.inTable = false;
    }

    public MibType(MibModule mibModule, String string) {
        this.name = string;
        this.module = mibModule;
        this.allowedValues = null;
        this.range = null;
    }

    public String toString() {
        String string = new String("--> ");
        if (this.name != null) {
            string = String.valueOf(string) + this.module.name + "." + this.name + ":";
        }
        if (this.displayHint != null) {
            string = String.valueOf(string) + "[" + this.displayHint + "]";
        }
        if (this.range != null) {
            string = String.valueOf(string) + this.range.toString();
        }
        return string;
    }

    public MibType getActualType() {
        return this;
    }

    public int getTypeEnum() {
        return 0;
    }

    public void addRangeSubtype(MibRangeSubtype mibRangeSubtype) {
        this.range = mibRangeSubtype;
    }

    public void addValueSubtype(MibValueSubtype mibValueSubtype) {
        this.allowedValues = mibValueSubtype;
    }

    public MibRangeSubtype getRangeSubtype() {
        return this.range;
    }

    public MibValueSubtype getValueSubtype() {
        return this.allowedValues;
    }

    protected void markInTable() {
        this.inTable = true;
    }

    public boolean isInTable() {
        return this.inTable;
    }

    public boolean isEnumerated() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public static String valToString(int n) {
        switch (n) {
            case 0: {
                return "Unknown";
            }
            case 1: {
                return "Counter";
            }
            case 2: {
                return "Gauge";
            }
            case 3: {
                return "Integer";
            }
            case 4: {
                return "IPAddress";
            }
            case 5: {
                return "DisplayString";
            }
            case 6: {
                return "NetworkAddress";
            }
            case 7: {
                return "NSAPAddress";
            }
            case 8: {
                return "ObjectIdentifier";
            }
            case 9: {
                return "OctetString";
            }
            case 10: {
                return "Opaque";
            }
            case 11: {
                return "Sequence";
            }
            case 12: {
                return "SequenceOf";
            }
            case 13: {
                return "TimeTicks";
            }
            case 14: {
                return "BitString";
            }
            case 15: {
                return "Counter64";
            }
        }
        return "Unknown";
    }

    public String getDisplayHint() {
        return this.displayHint;
    }
}

